function Figure6S1B()
% This script plots the data for Figure 6 - figure supplement 1B. 'X' data
% contains pre-F intensities, 'Y' data contains post-F intensities. Data
% from individual replicates is stored as separate variables (X1, X2, ...)

X0 = []; Q = 0;

load('PBS_0h.mat')
X = [X1 X2 X3 X4]; Y = [Y1 Y2 Y3 Y4];
[p,q] = hist(log10(Y./X),50); p = p/sum(p); i = find(p<0.001); p(i) = []; q(i) = [];
plot([p fliplr(-p)]+Q,[q fliplr(q)]); drawnow; hold on;
temp = [median(log10(Y1./X1)) median(log10(Y2./X2)) median(log10(Y3./X3)) median(log10(Y4./X4))];
X0 = [X0 ; temp];
plot(Q+[-.15 -.05 .05 .15]/5,temp,'ok','MarkerFaceColor','k'); hold on;
Q = Q + .3;

load('shocked_0h.mat')
X = [X1 X2 X3 X4]; Y = [Y1 Y2 Y3 Y4];
[p,q] = hist(log10(Y./X),50); p = p/sum(p); i = find(p<0.001); p(i) = []; q(i) = [];
plot([p fliplr(-p)]+Q,[q fliplr(q)]); drawnow; hold on;
temp = [median(log10(Y1./X1)) median(log10(Y2./X2)) median(log10(Y3./X3)) median(log10(Y4./X4))];
X0 = [X0 ; temp];
plot(Q+[-.15 -.05 .05 .15]/5,temp,'ok','MarkerFaceColor','k'); hold on;
Q = Q + .3;

load('PBS_24h.mat')
X = [X1 X2 X3 X4]; Y = [Y1 Y2 Y3 Y4];
[p,q] = hist(log10(Y./X),50); p = p/sum(p); i = find(p<0.001); p(i) = []; q(i) = [];
plot([p fliplr(-p)]+Q,[q fliplr(q)]); drawnow; hold on;
temp = [median(log10(Y1./X1)) median(log10(Y2./X2)) median(log10(Y3./X3)) median(log10(Y4./X4))];
X0 = [X0 ; temp];
plot(Q+[-.15 -.05 .05 .15]/5,temp,'ok','MarkerFaceColor','k'); hold on;
Q = Q + .3;

load('shocked_24h.mat')
X = [X1 X2 X3 X4]; Y = [Y1 Y2 Y3 Y4];
[p,q] = hist(log10(Y./X),50); p = p/sum(p); i = find(p<0.001); p(i) = []; q(i) = [];
plot([p fliplr(-p)]+Q,[q fliplr(q)]); drawnow; hold on;
temp = [median(log10(Y1./X1)) median(log10(Y2./X2)) median(log10(Y3./X3)) median(log10(Y4./X4))];
X0 = [X0 ; temp];
plot(Q+[-.15 -.05 .05 .15]/5,temp,'ok','MarkerFaceColor','k'); hold on;
Q = Q + .3;

[h,p0] = ttest2(X0(1,:),X0(2,:));
[h,p24] = ttest2(X0(3,:),X0(4,:));

disp(['P-value for the 0h comparison: ',num2str(p0)]);
disp(['P-value for the 24h comparison: ',num2str(p24)]);
